﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls.Survey
{
    public partial class SurveyQuestionFreeText : System.Web.UI.UserControl
    {
        public List<SURVEY_RESULTS> Questions { get; set; }
        public List<SURVEY_RESULTS> Results { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
        }

        public void BuildQuestion()
        {
            SURVEY_RESULTS question = Questions.First();
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            lblQuestion.ID = "lbl" + stdQuestion.ID.ToString();
            if (!string.IsNullOrEmpty(AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER)))
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER) + ") " + AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);
            else
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);

            if (question != null)
            {
                if (!string.IsNullOrWhiteSpace(stdQuestion.UNIT_HINT))
                {
                    lblUnitHint.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.UNIT_HINT);
                }
                txtResponse.ID = "txt" + question.SURVEY_RESULT_ID.ToString();
                txtResponse.ToolTip = "Enter a value for Question " + stdQuestion.QUESTION_NUMBER;

                if (!Page.IsPostBack)
                    txtResponse.Text = question.RESULT_TEXT;
                else
                {
                    if (Request != null && Request.Form != null && Request.Form["ctl00$MainContent$" + txtResponse.ID] != null)
                        txtResponse.Text = Request.Form["ctl00$MainContent$" + txtResponse.ID].ToString();
                }
            }
        }

        public string BuildNoteTemplate()
        {
            StringBuilder sbNote = new StringBuilder();

            SURVEY_RESULTS question = Questions.First();
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            lblQuestion.ID = "lbl" + stdQuestion.ID.ToString();
            if (!string.IsNullOrEmpty(stdQuestion.QUESTION_NUMBER))
            {
                string strQuestion = stdQuestion.QUESTION_NUMBER + ") " + stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine(strQuestion);
            }
            else
            {
                string strQuestion = stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine(strQuestion);
            }

            if (question != null && !string.IsNullOrWhiteSpace(question.RESULT_TEXT))
            {
                string unitHint = "";
                if (!string.IsNullOrWhiteSpace(stdQuestion.UNIT_HINT))
                {
                    unitHint = " " + AntiXssEnc.Encoder.HtmlEncode(stdQuestion.UNIT_HINT);
                }
                sbNote.AppendLine("- " + question.RESULT_TEXT + unitHint);
            }

            return sbNote.ToString();
        }

        public void SaveQuestion()
        {
            int resultId = 0;
            if (int.TryParse(txtResponse.ID.Replace("txt", ""), out resultId))
            {
                foreach (SURVEY_RESULTS result in Results)
                {
                    if (result.SURVEY_RESULT_ID == resultId)
                    {
                        result.RESULT_TEXT = txtResponse.Text;

                        CalculateResult(result);
                    }
                }
            }
        }

        public void CalculateResult(SURVEY_RESULTS result)
        {
            if (result.STD_QUESTION_ID == 1319)
            {
                double total = 0;

                var codes = new List<int>() { 1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318 };
                var surveyResults = Results.Where(x => codes.Contains(x.STD_QUESTION_ID));
                foreach (var surveyResult in surveyResults)
                {
                    if (surveyResult.SELECTED_FLAG)
                    {
                        int choiceValue = 0;
                        if (int.TryParse(surveyResult.STD_QUESTION_CHOICE.CHOICE_NAME, out choiceValue))
                        {
                            total += choiceValue;
                        }

                        //double resultValue = 0;
                        //if (double.TryParse(surveyResult.RESULT_TEXT, out resultValue))
                        //{
                        //    total += resultValue;
                        //}
                    }
                }

                result.RESULT_TEXT = Convert.ToString(total);
            }
        }
    }
}